-- V6.00 Six Feet Under update
-- V5.00 A Moderately Friendly update
-- V4.00 The Stuff of Nightmares update
-- V3.20 Proper WX78 upgrade animations when using the Neat versions
-- V3.10 Hungry for your hunger update
-- V3.02 No more incompatibilities with Display Food Values
-- V3.01 WX78 bugfix, fixed some wrong tex/anim files
-- V3.00 Strange New Powers update
-- V2.20 Added naughtiness tab
-- V2.10 Added background color to the containers slots
-- V2.03 Bugfix : the game won't crash if you use the shortcut for the backpack while not equipped
-- V2.02 Bugfix : if you are resurrected with the amulet you'll end up losing it like originally intended
-- V2.01 Bugfix : the game won't crash anymore when you downgrade to a smaller inventory version
-- V2.00 Underground - added shortcuts for the crafting tab (R) and the backpack (B) + cosmetic change to the crafting tab
-- V1.20 Increased the zoom out without the game making you go back to the default zoom
-- V1.10 Increased the size of the backpacks
-- V1.00 Realease version

-- Mod created By Kiopho
--------------------------------------------------------------------------------------------------------------------------

Assets = {
	Asset("ATLAS", "images/equipslots.xml"),
	Asset("ATLAS", "images/container.xml"),
	Asset("ATLAS", "images/inv_slot_spoiled.xml"),
	Asset("ATLAS", "images/inventory_bg55.xml"),
	Asset("ATLAS", "images/krampus_sack_bg.xml"),
}

Vector3 = GLOBAL.Vector3

--------------------------------------------------------------------------------------------------------------------------

-- Do not change
local function inventorypostinit(component,inst)
	inst.components.inventory.maxslots = 55
	inst.components.inventory.numequipslots = 5
end

AddComponentPostInit("inventory", inventorypostinit)
--

-- Making the spoiling food not cover the slots background
local function ItemTilePostInit(self, invitem)
	self.bg:SetTexture("images/inv_slot_spoiled.xml", "inv_slot_spoiled.tex")
end

AddClassPostConstruct("widgets/itemtile", ItemTilePostInit)
--

-- Custom slot background color
local function TintingPostInit(self, num, atlas, bgim, owner, container)
	if container.widgetbgimagetint then
		self.bgimage:SetTint(container.widgetbgimagetint.r, container.widgetbgimagetint.g, container.widgetbgimagetint.b, container.widgetbgimagetint.a)
    end
end

AddClassPostConstruct("widgets/invslot", TintingPostInit)
--

-- No Backpacks Overflow Functions
local function newbckonequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_body", "swap_backpack", "backpack")
	owner.AnimState:OverrideSymbol("swap_body", "swap_backpack", "swap_body")
	inst.components.container:Open(owner)
end

local function newpigonequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_body", "swap_piggyback", "backpack")
	owner.AnimState:OverrideSymbol("swap_body", "swap_piggyback", "swap_body")
	inst.components.container:Open(owner)
end

local function newkrmponequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_body", "swap_krampus_sack", "backpack")
	owner.AnimState:OverrideSymbol("swap_body", "swap_krampus_sack", "swap_body")
	inst.components.container:Open(owner)
end
--

-- Krampus sack
local function krampussackpostinit(inst)
	local slotpos = {}
	
	for y = 0, 9 do
	table.insert(slotpos, Vector3(-37, -y*75 + 338 ,0))
	table.insert(slotpos, Vector3(-37 +75, -y*75 + 338 ,0))
	end
	
	inst.components.container.numslots = #slotpos
	inst.components.container.widgetslotpos = slotpos
	inst.components.container.widgetanimbank = nil
	inst.components.container.widgetanimbuild = nil
	inst.components.container.widgetbgatlas = "images/krampus_sack_bg.xml"
	inst.components.container.widgetbgimage = "krampus_sack_bg.tex"
	inst.components.container.widgetpos = Vector3(-76,-57,0)
	
	inst.components.equippable.equipslot = GLOBAL.EQUIPSLOTS.PACK
	inst.components.inventoryitem.cangoincontainer = true
	inst:AddTag("nonpotatable")
	
	inst.components.equippable:SetOnEquip(newkrmponequip)
end

AddPrefabPostInit("krampus_sack", krampussackpostinit)
--

-- Piggyback
local function piggybackpostinit(inst)
	local slotpos = {}
	
	for y = 0, 6 do
	table.insert(slotpos, Vector3(-162, -y*75 + 240 ,0))
	table.insert(slotpos, Vector3(-162 +75, -y*75 + 240 ,0))
	end

	inst.components.container.numslots = #slotpos
	inst.components.container.widgetslotpos = slotpos
	inst.components.container.widgetanimbank = "ui_krampusbag_2x8"
	inst.components.container.widgetanimbuild = "ui_krampusbag_2x8"
	inst.components.container.widgetpos = Vector3(0,-75,0)

	inst.components.equippable.equipslot = GLOBAL.EQUIPSLOTS.PACK
	inst.components.inventoryitem.cangoincontainer = true
	inst.components.equippable.walkspeedmult = 1
	inst:AddTag("nonpotatable")
	
	inst.components.equippable:SetOnEquip(newpigonequip)
end

AddPrefabPostInit("piggyback", piggybackpostinit)
--

-- Backpack
local function backpackpostinit(inst)
	local slotpos = {}

	for y = 0, 4 do
	table.insert(slotpos, Vector3(-162, -y*75 + 112 ,0))
	table.insert(slotpos, Vector3(-162 +75, -y*75 + 112 ,0))
	end
	
	inst.components.container.numslots = #slotpos
	inst.components.container.widgetslotpos = slotpos
	inst.components.container.widgetanimbank = "ui_krampusbag_2x5"
	inst.components.container.widgetanimbuild = "ui_krampusbag_2x5"
	inst.components.container.widgetpos = Vector3(0,-50,0)
	
	inst.components.equippable.equipslot = GLOBAL.EQUIPSLOTS.PACK
	inst.components.inventoryitem.cangoincontainer = true
	inst:AddTag("nonpotatable")
	
	inst.components.equippable:SetOnEquip(newbckonequip)
end

AddPrefabPostInit("backpack", backpackpostinit)
--

-- Defines backpack slot
table.insert(GLOBAL.EQUIPSLOTS, "PACK")
GLOBAL.EQUIPSLOTS.PACK = "pack"
--

-- Chester
local function chesterpostinit(inst)
	local slotpos = {}

    for y = 3, 0, -1 do
		for x = 0, 3 do
		table.insert(slotpos, Vector3(80*x-80*2+40, 80*y-80*2+40,0))
		end
	end

	inst.components.container.widgetanimbank = nil
	inst.components.container.widgetanimbuild = nil
	inst.components.container.widgetbgatlas = "images/container.xml"
	inst.components.container.widgetbgimage = "container.tex"
	inst.components.container.widgetpos = Vector3(0,-200,0)
	inst.components.container.numslots = #slotpos
	inst.components.container.widgetslotpos = slotpos
	inst.components.container.widgetbgimagetint = {r=.75,g=.58,b=.44,a=1}
end

AddPrefabPostInit("chester", chesterpostinit)
--

-- Chests
local function treasurechestpostinit(inst)
	local slotpos = {}

	for y = 3, 0, -1 do
		for x = 0, 3 do
		table.insert(slotpos, Vector3(80*x-80*2+40, 80*y-80*2+40,0))
		end
	end

	inst.components.container.widgetanimbank = nil
	inst.components.container.widgetanimbuild = nil
	inst.components.container.widgetbgatlas = "images/container.xml"
	inst.components.container.widgetbgimage = "container.tex"
	inst.components.container.numslots = #slotpos
	inst.components.container.widgetslotpos = slotpos
	inst.components.container.widgetbgimagetint = {r=.82,g=.77,b=.7,a=1}
end

AddPrefabPostInit("treasurechest", treasurechestpostinit)
--

-- Ice Box
local function iceboxpostinit(inst)
	local slotpos = {}

	for y = 3, 0, -1 do
		for x = 0, 3 do
			table.insert(slotpos, Vector3(80*x-80*2+40, 80*y-80*2+40,0))
		end
	end

	inst.components.container.widgetanimbank = nil
	inst.components.container.widgetanimbuild = nil
	inst.components.container.widgetbgatlas = "images/container.xml"
	inst.components.container.widgetbgimage = "container.tex"
	inst.components.container.numslots = #slotpos
	inst.components.container.widgetslotpos = slotpos
	inst.components.container.widgetbgimagetint = {r=.44,g=.74,b=1,a=1}
end

AddPrefabPostInit("icebox", iceboxpostinit)
--

-- Crock Pot
local function crockpotpostinit(inst)
	inst.components.container.widgetbgimagetint = {r=1,g=.42,b=.33,a=1}
end

AddPrefabPostInit("cookpot", crockpotpostinit)
--

-- Amulets
local function amuletpostinit(inst)
	inst.components.equippable.equipslot = GLOBAL.EQUIPSLOTS.NECK
end

AddPrefabPostInit("amulet", amuletpostinit)
AddPrefabPostInit("blueamulet", amuletpostinit)
AddPrefabPostInit("purpleamulet", amuletpostinit)
AddPrefabPostInit("orangeamulet", amuletpostinit)
AddPrefabPostInit("greenamulet", amuletpostinit)
AddPrefabPostInit("yellowamulet", amuletpostinit)
--

-- Defines amulet slot
table.insert(GLOBAL.EQUIPSLOTS, "NECK")
GLOBAL.EQUIPSLOTS.NECK = "neck"
--

-- Cosmetic stuff : Buttons
local function Buttons(self)
	self.pauseBtn:Kill()
	self.minimapBtn:Kill()
	self.rotleft:Kill()
	self.rotright:Kill()
end

AddClassPostConstruct("widgets/mapcontrols", Buttons)
--

-- Cosmetic stuff : Craft tabs
local function CTabs(self)

	local oldSetOrientation = self.SetOrientation
	
	function self:SetOrientation(horizontal)
	
		oldSetOrientation(self, horizontal)
	
		local slot_w, slot_h = self.bg:GetSlotSize()
		local but_w, but_h = self.downbutton:GetSize()
	
		if horizontal then
			self.downbutton:SetRotation(90)
			self.downbutton:SetPosition(-self.bg.length/2 - but_w/2 + slot_w/2 +40,0,0)
			self.upbutton:SetRotation(-90)
			self.upbutton:SetPosition(self.bg.length/2 + but_w/2 - slot_w/2 - 40,0,0)
		else
			self.upbutton:SetPosition(0, - self.bg.length/2 - but_h/2 + slot_h/2 + 40,0)
			self.downbutton:SetScale(Vector3(1, -1, 1))
			self.downbutton:SetPosition(0, self.bg.length/2 + but_h/2 - slot_h/2 - 40,0)
		end
	end

end

AddClassPostConstruct("widgets/crafting", CTabs)
--

-- Do not change : makes the amulet resurrect
local function resurrectableinit(inst)
	inst.CanResurrect = function (self)
		local player = GLOBAL.GetPlayer()
		local item = nil
		if self.inst.components.inventory then
			item = self.inst.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.NECK)
		end
		
		if item and item.prefab == "amulet" then
			return true
		end

		local res = self:FindClosestResurrector()
		if res then
			return true
		end
	end

	inst.DoResurrect = function (self)
		local player = GLOBAL.GetPlayer()
		local item = nil
		self.inst:PushEvent("resurrect")
		if self.inst.components.inventory then
			item = self.inst.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.NECK)
			if item and item.prefab == "amulet" then
				self.inst.sg:GoToState("amulet_rebirth")
				return true
			end
		end
	
		local res = self:FindClosestResurrector()
		if res and res.components.resurrector then
			res.components.resurrector:Resurrect(self.inst)
			return true
		end
	end

end

AddComponentPostInit("resurrectable", resurrectableinit)
--

-- Do not change : removes the amulet when you die with it equipped
local function newOnExit(inst)

	inst.components.hunger:SetPercent(2/3)
	inst.components.health:Respawn(TUNING.RESURRECT_HEALTH)
	        
	if inst.components.sanity then
		inst.components.sanity:SetPercent(.5)
	end
	
	local item = inst.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.NECK)
	if item and item.prefab == "amulet" then
		item = inst.components.inventory:RemoveItem(item)
	end
	
	if item then
		item:Remove()
		item.persists = false
	end

	inst.HUD:Show()
	GLOBAL.TheCamera:SetDefault()
	inst.components.playercontroller:Enable(true)
    inst.AnimState:ClearOverrideSymbol("FX")

end

local function SGWilsonPostInit(sg)
	sg.states["amulet_rebirth"].onexit = newOnExit
end

AddStategraphPostInit("wilson", SGWilsonPostInit)
--

-- Shortcuts
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_B, function()
	local TheInput = GLOBAL.TheInput
	local player = GLOBAL.GetPlayer()
	local backpackslot = player.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.PACK)
	
	if not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) and not TheInput:IsKeyDown(GLOBAL.KEY_ALT) then
		if backpackslot and backpackslot.components.container then
			if backpackslot.components.container.open then
				backpackslot.components.container:Close()
			else
				backpackslot.components.container:Open(player)
			end
		end
	end
end)

GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_R, function()
	local controls = GLOBAL.GetPlayer().HUD.controls
	local TheInput = GLOBAL.TheInput
	
	if not TheInput:IsKeyDown(GLOBAL.KEY_CTRL) and not TheInput:IsKeyDown(GLOBAL.KEY_SHIFT) and not TheInput:IsKeyDown(GLOBAL.KEY_ALT) then
		if controls.left_root.shown then
				controls.left_root:Hide()
			else
				controls.left_root:Show()
			end	
	end
end)
--

-- Enabling the backpack to auto-open on load
 local function OpenBackpack(self) 
	
	local oldSetMainCharacter = self.SetMainCharacter

	function self:SetMainCharacter(maincharacter)
		
		oldSetMainCharacter(self, maincharacter)
        
		local bp = maincharacter.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.PACK)
		
		if bp and bp.components.container then
			bp.components.container:Close()
			bp.components.container:Open(maincharacter)
		end
	end
	
end

AddClassPostConstruct("screens/playerhud", OpenBackpack)
--

-- New Zoom Mecanics
local function Zoom(self)
	
	function self:UpdateClouds(dt)
	
		if not GLOBAL.GetWorld():IsCave() then

			local TheCamera = GLOBAL.TheCamera
			local TheMixer = GLOBAL.TheMixer
			local easing = GLOBAL.require("easing")

			if TheCamera and TheCamera.distance and not TheCamera.dollyzoom then
		
				local dist_percent = (TheCamera.distance - TheCamera.mindist) / (TheCamera.maxdist - TheCamera.mindist)
				local cutoff = .6
				if dist_percent > cutoff then
					if not self.clouds_on then
						TheCamera.should_push_down = false
						self.clouds_on = true
						self.clouds:Show()
						--self.owner.SoundEmitter:PlaySound("dontstarve/common/clouds", "windsound")
						--TheMixer:PushMix("high")
					end
	            
					local p = easing.outCubic( dist_percent-cutoff , 0, 1, 1 - cutoff) 
					--self.clouds:GetAnimState():SetMultColour(1,1,1, p )
					--self.owner.SoundEmitter:SetVolume("windsound",p)
				else
					if self.clouds_on then
						TheCamera.should_push_down = false
						self.clouds_on = false
						self.clouds:Hide()
						--self.owner.SoundEmitter:KillSound("windsound")
						TheMixer:PopMix("high")
					end
				end
			end
		end
	end
end

AddClassPostConstruct ("screens/playerhud", Zoom)
--

--[[ Inventory
local function Inventory(self)
	
	local HUD_ATLAS = "images/hud.xml"
	local Image = GLOBAL.Image
	local EQUIPSLOTS = GLOBAL.EQUIPSLOTS
	local EquipSlot = GLOBAL.require "widgets/equipslot"
	local InvSlot = GLOBAL.require "widgets/invslot"
	
	self:SetPosition(0,-16,0)
	
	self.bg:Kill()
	self.bg = self.root:AddChild(Image("images/inventory_bg55.xml", "inventory_bg55.tex"))
	self.bg:SetVRegPoint(GLOBAL.ANCHOR_BOTTOM)
	self.bg:SetScale(1.654,1,0)
	
	self:AddEquipSlot(EQUIPSLOTS.NECK, "images/equipslots.xml", "equip_slot_neck.tex")
	self:AddEquipSlot(EQUIPSLOTS.PACK, "images/equipslots.xml", "equip_slot_pack.tex")
	
	local W = 64
	local SEP = 7
	local INTERSEP = 11
	local y = 132/2
	local YSEP = 8

	local Widget = GLOBAL.require "widgets/widget"
	local ItemTile = GLOBAL.require "widgets/itemtile"
	local TheInput = GLOBAL.TheInput
		
	function self:Rebuild()

		if self.cursor then
			self.cursor:Kill()
			self.cursor = nil
		end
		
		if self.toprow then
			self.toprow:Kill()
		end

		if self.bottomrow then
			self.bottomrow:Kill()
		end

		self.toprow = self.root:AddChild(Widget("toprow"))
		self.bottomrow = self.root:AddChild(Widget("toprow"))

		self.inv = {}
		self.equip = {}
		self.backpackinv = {}

		local y = self.owner.components.inventory.overflow and (W/2+YSEP/2) or 0
		local eslot_order = {}

		local num_slots = self.owner.components.inventory:GetNumSlots()
		local num_equip = #self.equipslotinfo
		local num_intersep = math.floor(.2*(num_slots - 30))    
		local total_w = (num_slots + num_equip - 30)*(W) + (num_slots + num_equip - 30 - 1 - num_intersep)*(SEP) + (INTERSEP*num_intersep)
		
		for k, v in ipairs(self.equipslotinfo) do
			local slot = EquipSlot(v.slot, v.atlas, v.image, self.owner)
			self.equip[v.slot] = self.toprow:AddChild(slot)
			local x = total_w/2 - W/2 - (5-k)*W - (5-k)*SEP
			slot:SetPosition(x,y+71,0)
			table.insert(eslot_order, slot)
			
			local item = self.owner.components.inventory:GetEquippedItem(v.slot)
			if item then
				slot:SetTile(ItemTile(item, self.owner.components.inventory))
			end

		end    

		for k = 1,30 do
			local slot = InvSlot(k, HUD_ATLAS, "inv_slot.tex", self.owner, self.owner.components.inventory)
			self.inv[k] = self.toprow:AddChild(slot)
			local interseps = math.floor((k-1) / 5)
			local x = -total_w/2 + W/2 + interseps*(INTERSEP - SEP) + (k-1)*W + (k-1)*SEP
			slot:SetPosition(x,y,0)
			
			local item = self.owner.components.inventory:GetItemInSlot(k)
			if item then
				slot:SetTile(ItemTile(item, self.owner.components.inventory))
			end
			
		end
		
		for k = 31,55 do
			local slot = InvSlot(k, HUD_ATLAS, "inv_slot.tex", self.owner, self.owner.components.inventory)
			self.inv[k] = self.toprow:AddChild(slot)
			local interseps = math.floor((k-1-30) / 5)
			local x = -total_w/2 + W/2 + interseps*(INTERSEP - SEP) + (k-1-30)*W + (k-1-30)*SEP
			slot:SetPosition(x,y + 71,0)
			
			local item = self.owner.components.inventory:GetItemInSlot(k)
			if item then
				slot:SetTile(ItemTile(item, self.owner.components.inventory))
			end
			
		end

		local old_backpack = self.backpack
		if self.backpack then
			self.inst:RemoveEventCallback("itemget", BackpackGet, self.backpack)
			self.inst:ListenForEvent("itemlose", BackpackLose, self.backpack)
			self.backpack = nil
		end


		local new_backpack = self.owner.components.inventory.overflow
		local do_integrated_backpack = TheInput:ControllerAttached() and new_backpack
		if do_integrated_backpack then
			local num = new_backpack.components.container.numslots



			local x = - (num * (W+SEP) / 2)
			local offset = #self.inv >= num and 1 or 0 --math.ceil((#self.inv - num)/2)
			
			for k = 1, num do
				local slot = InvSlot(k, HUD_ATLAS, "inv_slot.tex", self.owner, new_backpack.components.container)
				self.backpackinv[k] = self.bottomrow:AddChild(slot)
				
				if offset > 0 then
					slot:SetPosition(self.inv[offset+k-1]:GetPosition().x,0,0)
				else
					slot:SetPosition(x,0,0)
					x = x + W + SEP
				end
				
				local item = new_backpack.components.container:GetItemInSlot(k)
				if item then
					slot:SetTile(ItemTile(item, new_backpack.components.container))
				end
				
			end
			
			self.backpack = self.owner.components.inventory.overflow
			self.inst:ListenForEvent("itemget", BackpackGet, self.backpack)
			self.inst:ListenForEvent("itemlose", BackpackLose, self.backpack)
		end



		if old_backpack	and not self.backpack then
			self:SelectSlot(self.inv[1])
			self.current_list = self.inv
		end

		--self.bg:Flow(total_w+60, 256, true)
		
		if do_integrated_backpack then
			self.bg:SetPosition(Vector3(0,-24,0))
			self.toprow:SetPosition(Vector3(0,W/2 + YSEP/2,0))
			self.bottomrow:SetPosition(Vector3(0,-W/2 - YSEP/2,0))
			self.root:MoveTo(self.out_pos, self.in_pos, .5)
		else
			self.bg:SetPosition(Vector3(-2, -66, 0))
			self.toprow:SetPosition(Vector3(0,0,0))
			self.bottomrow:SetPosition(0,0,0)
			
			if TheInput:ControllerAttached() then
				self.root:MoveTo(self.in_pos, self.out_pos, .2)
			else
				self.root:SetPosition(self.out_pos)
			end
			
			
		end
		
		self.actionstring:MoveToFront()
		
		self:SelectSlot(self.inv[1])
		self.current_list = self.inv
		self:UpdateCursor()
		
		if self.cursor then
			self.cursor:MoveToFront()
		end


		self.rebuild_pending = false
	end
end

AddClassPostConstruct("widgets/inventorybar", Inventory)
--]]